/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取大屏相关数据
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 *************************************************************************************************/


/* exported  mc_screen_send_box_date */
/* exported  mc_screen_read_box_date */
/* exported  mc_set_normal_val */
/* exported  mc_screen_read_send_card */


/* global  $ */
/* global  mc_sdk_param */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体偏移信息
 * 参数:
 *    @param {Promise<function>} fun_callback               回调函数
 *    @param {Promise<string>} str_send_inx         发送卡ID
 *    @param {Promise<string>} str_send_por    发送卡出口ID
 *    @param {Promise<string>} str_hub_id  发送卡HUB串种的顺序(目前不用 保留)
 *    @param {Promise<string>} str_hub_port      发送卡HUB发送的出口ID(目前不用 保留)
 *    @param {Promise<string>} str_rece_idx         接收卡串的顺序
 *    @param {Promise<string>} str_eth_x         网口水平偏移(目前不用 保留)
 *    @param {Promise<string>} str_eth_y         网口垂直偏移(目前不用 保留)
 *    @param {Promise<string>} str_img_x         图像水平偏移
 *    @param {Promise<string>} str_img_y         图像垂直偏移
 *    @param {Promise<array>} arr_circle_times         每组网口的下发接收卡数量
 *    @param {Promise<array>} str_ctrl_name         主控芯片名称

 * 返回：
 *       @param {Promise<string>}date_screen 错误码标识
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.10
 *      内容 : 所有代码
 ************************************************************************************************/


function mc_screen_send_box_date(fun_callback, str_send_inx, str_send_por, str_hub_id, str_hub_port, str_rece_idx, str_eth_x, str_eth_y, arr_circle_times, str_ctrl_name) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var str_img_x = "";
    var str_img_y = "";

    str_img_x = arr_circle_times[0].x;
    str_img_y = arr_circle_times[0].y;
    var str_screen_send_json_req = new mc_sdk_param();
    var str_param_val = "(" + str_send_inx + ":" + str_send_por + ":" + str_hub_id + ":" + str_hub_port + ":" + str_rece_idx + ")";
    var str_attr_val = "(" + str_eth_x + ":" + str_eth_y + ":" + str_img_x + ":" + str_img_y + ")";

    str_screen_send_json_req.set_param_clear();
    str_screen_send_json_req.set_cmd("SET_PARAM");
    str_screen_send_json_req.set_func("HW_BOX_OFFSET");
    str_screen_send_json_req.set_param_value("RECVCARD", str_param_val);
    str_screen_send_json_req.set_attr_val("RECVCARD", "CMD", str_attr_val);
    str_screen_send_json_req.set_attr_val("RECVCARD", "CHIPNAME", str_ctrl_name);
    str_screen_send_json_req.set_attr_val("RECVCARD", "MEMTYPE", "RAM");

    // console.log(str_attr_val);
    // console.log(str_param_val);

    $.post("/access_shell", str_screen_send_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var str_param_screen = new mc_sdk_param();

        str_param_screen.set_json(result);
        var date_screen = str_param_screen.get_param_value("ERROR_CODE");

        // console.log(date_screen);
        fun_callback(arr_circle_times.shift(), date_screen);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取箱体偏移信息
 * 参数:
 *    @param {Promise<function>} fun_callback               回调函数
 *    @param {Promise<string>} str_send_inx         发送卡ID
 *    @param {Promise<string>} str_send_por    发送卡出口ID
 *    @param {Promise<string>} str_hub_id  发送卡HUB串种的顺序(目前不用 保留)
 *    @param {Promise<string>} str_hub_port      发送卡HUB发送的出口ID(目前不用 保留)
 *    @param {Promise<string>} str_rece_idx         接收卡串的顺序
 *    @param {Promise<string>} str_ctrl_name        主控芯片名称


 * 返回：
 *    @param {Promise<string>} str_eth_x         网口水平偏移(目前不用 保留)
 *    @param {Promise<string>} str_eth_y         网口垂直偏移(目前不用 保留)
 *    @param {Promise<string>} str_img_x         图像水平偏移
 *    @param {Promise<string>} str_img_y         图像垂直偏移
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.12
 *      内容 : 所有代码
 ************************************************************************************************/


function mc_screen_read_box_date(fun_callback, str_send_inx, str_send_por, str_hub_id, str_hub_port, str_rece_idx, str_ctrl_name) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var str_screen_read_json_req = new mc_sdk_param();
    var str_param_val = "(" + str_send_inx + ":" + str_send_por + ":" + str_hub_id + ":" + str_hub_port + ":" + str_rece_idx + ")";

    // console.log(str_param_val);

    str_screen_read_json_req.set_param_clear();
    str_screen_read_json_req.set_cmd("GET_PARAM");
    str_screen_read_json_req.set_func("HW_BOX_OFFSET");
    str_screen_read_json_req.set_param_value("RECVCARD", str_param_val);
    str_screen_read_json_req.set_attr_val("RECVCARD", "CHIPNAME", str_ctrl_name);
    str_screen_read_json_req.set_attr_val("RECVCARD", "MEMTYPE", "RAM");


    $.post("/access_shell", str_screen_read_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }

        var str_screen_read_box_date = new mc_sdk_param();

        str_screen_read_box_date.set_json(result);
        var str_screen_code = str_screen_read_box_date.get_param_value("ERROR_CODE");
        var str_screen_val = str_screen_read_box_date.get_param_value("OFFSET");

        fun_callback(str_screen_val, str_screen_code);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取硬件数据
 * 参数:
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    发送卡类型,id,名称,接收卡数量
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.18
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_screen_read_send_card(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_cmd("GET_PARAM");
    obj_sdk_param_req.set_func("HW_CONNECT_INFO");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        obj_sdk_param_req.set_param_clear();
        obj_sdk_param_req.set_json(_response);


        var obj_send_card_date = {
            "hardware_id": "",
            "hardware_version": "",
            "hardware_fpga_version": "",
            "hardware_mcu_version": "",
            "hardware_eth_status": ""
        };

        var hardware_id = obj_sdk_param_req.get_attr_val("0", "ID");
        var hardware_version = obj_sdk_param_req.get_attr_val("0", "VERSION");
        var hardware_fpga_version = obj_sdk_param_req.get_attr_val("0", "FPGA_VERSION");
        var hardware_mcu_version = obj_sdk_param_req.get_attr_val("0", "MCU_VERSION");
        var hardware_eth_status = obj_sdk_param_req.get_attr_val("0", "ETH_STATUS");

        obj_send_card_date.hardware_id = hardware_id;
        obj_send_card_date.hardware_version = hardware_version;
        obj_send_card_date.hardware_fpga_version = hardware_fpga_version;
        obj_send_card_date.hardware_mcu_version = hardware_mcu_version;
        obj_send_card_date.hardware_eth_status = hardware_eth_status;


        fun_callback(obj_send_card_date);
    }, "text");
}
